

<?php $__env->startSection('title'); ?>
    <?php echo e(__('My Orders')); ?> <?php echo e(__('-')); ?> <?php echo e($settings->site_title); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <section class="orders">
  <div class="mx-auto container mx-auto text-center m-4">
    <div class="pxa-4 md:px-0">
      <div class="bg-white border rounded-lg overflow-hidden mx-auto mr-2">
        <div class="text-left px-3 flex items-center justify-between">
          <div class="flex items-center">
            <svg viewBox="0 0 24 24" class="mr-2" style="width: 24px; height: 24px">
              <path fill="currentColor" d="M11 15H17V17H11V15M9 7H7V9H9V7M11 13H17V11H11V13M11 9H17V7H11V9M9 11H7V13H9V11M21 5V19C21 20.1 20.1 21 19 21H5C3.9 21 3 20.1 3 19V5C3 3.9 3.9 3 5 3H19C20.1 3 21 3.9 21 5M19 5H5V19H19V5M9 15H7V17H9V15Z"></path>
            </svg>
            <h2 class="text-lg text-black py-2 font-normal fb"> <?php echo e(__('My Orders')); ?></h2>
          </div>
        </div>
        <hr>  <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <!--- item --->
        <div class="orders-list border-b-2 m-2">
          <div class="sm:flex">
            <div class="w-full sm:w-1/2">
              <p class="px-3 py-1 text-left">
                <span class="font-bold"><?php echo e(__('Order ID')); ?>: </span> <?php echo e($order->id); ?>

              </p>
              <p class="px-3 py-1 text-left">
                <span class="font-bold"><?php echo e(__('Date')); ?>: </span> <?php echo e(custom_date($order)); ?>

              </p>
              <p class="px-3 py-1 text-left">
                <span class="font-bold"><?php echo e(__('Package')); ?>: </span> 
                                    <?php if(!empty($order->variation->title)): ?>
                                        <?php echo e($order->variation->title); ?>

                                    <?php endif; ?>
              </p>
            </div>
            <div class="w-full sm:w-1/2">
              
                <?php if(!empty($order->account_info)): ?>         
<?php
$accountInfo = json_decode(json_encode($order->account_info), true);
?>
<?php if(isset($accountInfo['account_type'])): ?>
 <p class="px-3 py-1 text-left"><span class="font-bold">Account Type: </span> <?php echo e($accountInfo['account_type']); ?></p>
 <p class="px-3 py-1 text-left"><span class="font-bold">Game Account: </span> <?php echo e($accountInfo['game_account']); ?></p>
 <p class="px-3 py-1 text-left"><span class="font-bold">Game Password: </span> <?php echo e($accountInfo['game_password']); ?></p>
 <p class="px-3 py-1 text-left"><span class="font-bold">Game Backup: </span> <?php echo e($accountInfo['game_backup']); ?></p>
<?php endif; ?>
<?php if(isset($accountInfo['player_id'])): ?>
 <p class="px-3 py-1 text-left"><span class="font-bold">Player ID: </span> <?php echo e($accountInfo['player_id']); ?></p>
<?php endif; ?>
<?php if(isset($accountInfo['subscription_details'])): ?>
 <p class="px-3 py-1 text-left"><span class="font-bold">Subscription Details: </span> <?php echo e($accountInfo['subscription_details']); ?></p>
<?php endif; ?>
                <?php endif; ?>
           

              <p class="px-3 py-1 text-left">
                <span class="font-bold"><?php echo e(__('Price')); ?>: </span> <?php echo e(price($order->amount)); ?>

              </p>
              <p class="px-3 py-1 text-left">
                <span class="font-bold"><?php echo e(__('Status')); ?>: </span>
                <span class="<?php echo e(\App\Constants\OrderStatus::color($order->status)); ?>">
                  <span class="order-status"><?php echo e(strtolower($order->status)); ?></span> <?php if($order->isPending()): ?> <a class="btn theme-btn btn-sm btn-right-mobile" style="padding: 3px 6px;" href="<?php echo e(route('user.order.pay', ['id' => $order->id])); ?>">
                    <?php echo e(__('Pay Now')); ?>

                  </a> <?php endif; ?> </span>
              </p>

          </div>
        </div>
        </div>
        <!--- /item ---> 
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?> <div class="box-form mx-auto w-36 order-not-found">
          <h4 class="fb-normal text-base">No order found !</h4>
          <a href="../?#topup" class="bg-red-500 border border-red-500 hover:bg-red-500 text-white text-xs py-1 px-2 md:px-2 rounded uppercase paglabazar-btn"> Order Now </a>
        </div> 
        <?php endif; ?> 
        <?php if($orders->lastPage() > 1): ?> 
        <p class="p-3 text-gray-800 text-center border border-b">
          <?php echo e($orders->links('pagination')); ?>

        </p> 
        <?php endif; ?>
      </div>
    </div>
  </div>
</section> 

    <div id="delivery_message" class="modal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo e(__('Delivery Message')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="text-left" style="padding: 20px;" id="show_message"></div>
                </div>
                <div class="modal-footer">
                    <a href="<?php echo e(route('page', ['slug' => 'contact-us'])); ?>" type="button"
                        class="btn theme-btn"><?php echo e(__('Contact Us')); ?></a>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                </div>
            </div>
        </div>
    </div>

    <div id="order_note" class="modal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo e(__('Order Note')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="text-left" style="padding: 20px;" id="show_note"></div>
                </div>
                <div class="modal-footer">
                    <a href="<?php echo e(route('page', ['slug' => 'contact-us'])); ?>" type="button"
                        class="btn theme-btn"><?php echo e(__('Contact Us')); ?></a>
                    <button type="button" class="btn btn-secondary"
                        data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <?php echo $__env->make('scripts.user.common', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/streamhi/cp.buildwithbytes.shop/core/resources/views/user/orders.blade.php ENDPATH**/ ?>